/*
 * Decompiled with CFR 0.152.
 */
package com.fm.openinstall;

import android.app.Activity;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.fm.openinstall.Configuration;
import com.fm.openinstall.OpenInstallHelper;
import com.fm.openinstall.SharePlatform;
import com.fm.openinstall.listener.AppInstallListener;
import com.fm.openinstall.listener.AppInstallRetryAdapter;
import com.fm.openinstall.listener.AppWakeUpListener;
import com.fm.openinstall.listener.ResultCallback;
import io.openinstall.sdk.b;
import io.openinstall.sdk.bf;
import io.openinstall.sdk.c;
import io.openinstall.sdk.cb;
import io.openinstall.sdk.cc;
import io.openinstall.sdk.cd;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Map;

public final class OpenInstall {
    private static volatile boolean a = false;

    private OpenInstall() {
    }

    @NonNull
    public static String getVersion() {
        return "2.8.1";
    }

    @Nullable
    public static String getOpid() {
        if (!OpenInstall.a()) {
            return null;
        }
        return b.a().b();
    }

    public static void init(@NonNull Context context) {
        OpenInstall.init(context, Configuration.getDefault());
    }

    public static void init(@NonNull Context context, @NonNull String appKey) {
        OpenInstall.init(context, appKey, Configuration.getDefault());
    }

    public static void init(@NonNull Context context, @Nullable Configuration configuration) {
        String string = cc.a(context);
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("\u8bf7\u5728AndroidManifest.xml\u4e2d\u914d\u7f6eOpenInstall\u63d0\u4f9b\u7684AppKey");
        }
        OpenInstall.init(context, string, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(@NonNull Context context, @NonNull String appKey, @Nullable Configuration configuration) {
        Object object;
        long l2 = System.currentTimeMillis();
        if (context == null) {
            throw new IllegalArgumentException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)appKey)) {
            throw new IllegalArgumentException("\u8bf7\u524d\u5f80OpenInstall\u63a7\u5236\u53f0\u7684 \u201cAndroid\u96c6\u6210\u201d -> \u201cAndroid\u5e94\u7528\u914d\u7f6e\u201d \u4e2d\u83b7\u53d6AppKey");
        }
        if (cb.a) {
            cb.a("SDK Version : " + OpenInstall.getVersion(), new Object[0]);
        }
        c.a().a(context.getApplicationContext());
        c.a().a(appKey);
        c.a().a(configuration);
        WeakReference<Activity> weakReference = null;
        if (context instanceof Activity) {
            object = (Activity)context;
            weakReference = new WeakReference<Activity>((Activity)object);
        }
        object = OpenInstall.class;
        synchronized (OpenInstall.class) {
            if (!a) {
                b.a().a(weakReference, l2);
                a = true;
            }
            // ** MonitorExit[var6_5 /* !! */ ] (shouldn't be in output)
            return;
        }
    }

    public static void setChannel(String channel) {
        c.a().b(channel);
    }

    public static void setDebug(boolean debug) {
        cb.a = debug;
    }

    public static void clipBoardEnabled(boolean enabled) {
        c.a().a(enabled);
    }

    public static void setTrackData(@Nullable ClipData trackData) {
        c.a().a(trackData);
        c.a().a(false);
    }

    @Deprecated
    public static void serialEnabled(boolean enabled) {
        c.a().b(enabled);
    }

    public static boolean getWakeUp(@Nullable Intent intent, @NonNull AppWakeUpListener appWakeUpListener) {
        if (!OpenInstall.a()) {
            return false;
        }
        if (OpenInstallHelper.isSchemeWakeup(intent)) {
            b.a().a(intent, appWakeUpListener);
            return true;
        }
        return false;
    }

    public static void getWakeUpAlwaysCallback(@Nullable Intent intent, @NonNull AppWakeUpListener appWakeUpListener) {
        if (!OpenInstall.a()) {
            bf bf2 = bf.a.a.a();
            appWakeUpListener.onWakeUpFinish(null, bf2.c());
            return;
        }
        if (OpenInstallHelper.isSchemeWakeup(intent)) {
            b.a().a(intent, appWakeUpListener);
            return;
        }
        bf bf3 = bf.a.g.a();
        appWakeUpListener.onWakeUpFinish(null, bf3.c());
    }

    public static boolean getWakeUpYYB(@NonNull Activity activity, @Nullable Intent intent, @NonNull AppWakeUpListener appWakeUpListener) {
        if (!OpenInstall.a()) {
            return false;
        }
        if (OpenInstallHelper.isSchemeWakeup(intent)) {
            b.a().a(intent, appWakeUpListener);
            return true;
        }
        if (OpenInstallHelper.isLauncherFromYYB(activity, intent)) {
            b.a().a(appWakeUpListener);
            return true;
        }
        return false;
    }

    public static void getWakeUpYYBAlwaysCallback(@NonNull Activity activity, @Nullable Intent intent, @NonNull AppWakeUpListener appWakeUpListener) {
        if (!OpenInstall.a()) {
            bf bf2 = bf.a.a.a();
            appWakeUpListener.onWakeUpFinish(null, bf2.c());
            return;
        }
        if (OpenInstallHelper.isSchemeWakeup(intent)) {
            b.a().a(intent, appWakeUpListener);
            return;
        }
        if (OpenInstallHelper.isLauncherFromYYB(activity, intent)) {
            b.a().a(appWakeUpListener);
            return;
        }
        bf bf3 = bf.a.g.a();
        appWakeUpListener.onWakeUpFinish(null, bf3.c());
    }

    public static void getInstall(@NonNull AppInstallListener appInstallListener) {
        OpenInstall.getInstall(appInstallListener, 10);
    }

    public static void getInstall(@NonNull AppInstallListener appInstallListener, int seconds) {
        if (!OpenInstall.a()) {
            bf bf2 = bf.a.a.a();
            appInstallListener.onInstallFinish(null, bf2.c());
            return;
        }
        if (cb.a && seconds < 5) {
            cb.b("getInstall\u8bbe\u7f6e\u8d85\u65f6\u65f6\u95f4\u8fc7\u5c0f\uff0c\u6613\u9020\u6210\u6570\u636e\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u589e\u5927\u8d85\u65f6\u65f6\u95f4\u6216\u8c03\u6574\u8c03\u7528\u65f6\u673a", new Object[0]);
        }
        b.a().a(false, seconds, appInstallListener);
    }

    public static void getInstallCanRetry(@NonNull AppInstallRetryAdapter retryListener, int seconds) {
        if (!OpenInstall.a()) {
            bf bf2 = bf.a.a.a();
            retryListener.onInstallFinish(null, bf2.c());
            return;
        }
        b.a().a(true, seconds, retryListener);
    }

    public static void reportRegister() {
        if (!OpenInstall.a()) {
            return;
        }
        b.a().c();
    }

    public static void reportEffectPoint(@NonNull String pointId, long pointValue) {
        if (!OpenInstall.a()) {
            return;
        }
        b.a().a(pointId, pointValue);
    }

    public static void reportEffectPoint(@NonNull String pointId, long pointValue, Map<String, String> extraMap) {
        if (!OpenInstall.a()) {
            return;
        }
        b.a().a(pointId, pointValue, extraMap);
    }

    public static void reportShare(@NonNull String shareCode, SharePlatform sharePlatform, ResultCallback<Void> resultCallback) {
        OpenInstall.reportShare(shareCode, sharePlatform.name(), resultCallback);
    }

    public static void reportShare(@NonNull String shareCode, @NonNull String sharePlatform, ResultCallback<Void> resultCallback) {
        if (!OpenInstall.a()) {
            bf bf2 = bf.a.a.a();
            resultCallback.onResult(null, bf2.c());
            return;
        }
        b.a().a(shareCode, sharePlatform, resultCallback);
    }

    private static boolean a() {
        if (!a) {
            if (cb.a) {
                cb.c("\u8bf7\u5148\u8c03\u7528 init(Context) \u521d\u59cb\u5316", new Object[0]);
            }
            return false;
        }
        return true;
    }

    @Deprecated
    public static void getUpdateApk(@NonNull ResultCallback<File> resultCallback) {
        if (!OpenInstall.a()) {
            bf bf2 = bf.a.a.a();
            resultCallback.onResult(null, bf2.c());
            return;
        }
        b.a().a(resultCallback);
    }

    @Deprecated
    public static void initWithPermission(@NonNull Activity activity, @Nullable Configuration configuration) {
        OpenInstall.initWithPermission(activity, configuration, null);
    }

    @Deprecated
    public static void initWithPermission(@NonNull Activity activity, @Nullable Configuration configuration, @NonNull Runnable delayTask) {
        if (cb.a) {
            cb.b("initWithPermission \u65b9\u6cd5\u5728\u540e\u7eed\u7248\u672c\u4e2d\u5c06\u88ab\u79fb\u9664\uff0c\u8bf7\u81ea\u884c\u8fdb\u884c\u6743\u9650\u7533\u8bf7", new Object[0]);
        }
        if (!cd.a((Context)activity)) {
            cd.a(activity, new String[]{"android.permission.READ_PHONE_STATE"}, 987);
            c.a().a(activity.getApplicationContext());
            c.a().a(delayTask);
            c.a().a(configuration);
        } else {
            OpenInstall.a(activity.getApplicationContext(), configuration, delayTask);
        }
    }

    public static void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        Context context = c.a().b();
        if (context != null && requestCode == 987) {
            Configuration configuration = c.a().e();
            Runnable runnable = c.a().j();
            OpenInstall.a(context, configuration, runnable);
        }
    }

    private static void a(@NonNull Context context, @Nullable Configuration configuration, Runnable runnable) {
        OpenInstall.init(context, configuration);
        if (runnable != null) {
            runnable.run();
            c.a().a((Runnable)null);
        }
    }
}

